/*
 * Decompiled with CFR 0.152.
 */
package clsvis.model;

import clsvis.Utils;
import clsvis.model.RelationDirection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;

public enum RelationType {
    SuperClass("&nbsp;&uarr;", "&nbsp;&darr;"),
    SuperInterface("&nbsp;&uarr;", "&nbsp;&darr;", 0xA9A9A9),
    InnerClass("&oplus;", "&otimes;"),
    Association("&rarr;", "&larr;"),
    Dependency("&rarr;", "&larr;", 0xA9A9A9),
    DependencyThrows("&rarr;", "&larr;", 0xA90000),
    DependencyAnnotation("&rarr;", "&larr;", 0x808000);

    public final int colorNum;
    private final Map<RelationDirection, String> asStringPriv = new EnumMap<RelationDirection, String>(RelationDirection.class);
    public final Map<RelationDirection, String> asString = Collections.unmodifiableMap(this.asStringPriv);

    private RelationType(String toSymbol, String fromSymbol) {
        this(toSymbol, fromSymbol, 0);
    }

    private RelationType(String toSymbol, String fromSymbol, int color) {
        this.colorNum = color;
        this.asStringPriv.put(RelationDirection.Outbound, RelationType.asString(toSymbol, color));
        this.asStringPriv.put(RelationDirection.Inbound, RelationType.asString(fromSymbol, color));
    }

    private static String asString(String symbol, int color) {
        return String.format("<span color=%s>%s</span> ", Utils.colorAsRRGGBB(color), symbol);
    }
}

