/*
 * Decompiled with CFR 0.152.
 */
package clsvis.model;

import clsvis.Utils;
import clsvis.gui.ColorContext;
import clsvis.model.ElementKind;
import clsvis.model.ElementModifier;
import clsvis.model.ElementVisibility;
import java.beans.ConstructorProperties;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;

public abstract class LangElement
implements Comparable<LangElement> {
    public final String id;
    public final String name;
    public final String fullTypeName;
    public final String shortTypeName;
    public final String originalTypeName;
    public final ElementKind kind;
    public final ElementVisibility visibility;
    public final Collection<ElementModifier> modifiers;

    @ConstructorProperties(value={"id", "name", "type", "genericType", "modifiers", "kind", "visibility"})
    public LangElement(String id, String name, Class type, Type genericType, Collection<ElementModifier> modifiers, ElementKind kind, ElementVisibility visibility) {
        String shortTypeName;
        String fullTypeName;
        this.id = id;
        this.name = name;
        this.kind = kind;
        this.visibility = visibility;
        this.modifiers = modifiers.isEmpty() ? Collections.EMPTY_SET : EnumSet.copyOf(modifiers);
        Class<?> originalType = Utils.getClassType(type);
        this.originalTypeName = originalType != null ? type.getName() : null;
        String string = fullTypeName = genericType instanceof Class ? type.getCanonicalName() : genericType.toString();
        if (fullTypeName == null) {
            fullTypeName = type.getName();
        }
        this.fullTypeName = fullTypeName;
        String string2 = shortTypeName = genericType instanceof Class ? type.getSimpleName() : this.fullTypeName;
        if (shortTypeName == null || shortTypeName.length() == 0) {
            shortTypeName = this.fullTypeName;
        }
        this.shortTypeName = shortTypeName.replaceAll("\\w+[\\.\\$](?!\\d+)", "");
    }

    public boolean isAbstract() {
        return this.modifiers.contains((Object)ElementModifier.Abstract);
    }

    public boolean isStatic() {
        return this.modifiers.contains((Object)ElementModifier.Static);
    }

    public String getStereotypesAsString(String separator, boolean withoutAbstractAndStatic) {
        if (separator == null) {
            separator = "";
        }
        StringBuilder sb = new StringBuilder(128);
        for (ElementModifier modifier : this.modifiers) {
            if (ElementModifier.visibilityModifiers.contains((Object)modifier) || modifier == ElementModifier.Abstract && withoutAbstractAndStatic || modifier == ElementModifier.Static && withoutAbstractAndStatic) continue;
            sb.append("<span color=").append(ColorContext.UmlStereotype.colorStr).append(">\u00ab").append((Object)modifier).append("\u00bb</span>");
            sb.append(separator);
        }
        return sb.toString();
    }

    public String getSignature() {
        return this.name;
    }

    public String getDeclarationSuffix() {
        return "";
    }

    public String toString() {
        return String.format("<html>%s%s%s%s %s : <span color=%s>%s</span>%s%s%s %s", this.kind.symbolStr, this.isStatic() ? "<u>" : "", this.isAbstract() ? "<i>" : "", this.visibility.symbolStr, this.name, ColorContext.UmlType.colorStr, this.fullTypeName.replace("<", "&lt;"), this.getDeclarationSuffix(), this.isAbstract() ? "</i>" : "", this.isStatic() ? "</u>" : "", this.getStereotypesAsString(" ", false));
    }

    public boolean equals(Object other) {
        return this.id.equals(other != null && other instanceof LangElement ? ((LangElement)other).id : null);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public int compareTo(LangElement other) {
        int result = this.name.compareTo(other.name);
        if (result == 0) {
            result = this.id.compareTo(other.id);
        }
        return result;
    }
}

