/*
 * Decompiled with CFR 0.152.
 */
package clsvis.logging;

import java.io.ByteArrayOutputStream;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;

public final class GUIHandler
extends StreamHandler {
    private static final int MAX_LINES = 512;
    private static JTextArea textArea;
    private final ByteArrayOutputStream outputBuffer = new ByteArrayOutputStream(8192);

    public GUIHandler() {
        this.setOutputStream(this.outputBuffer);
    }

    @Override
    public synchronized void publish(LogRecord record) {
        super.publish(record);
        this.flush();
        if (textArea != null) {
            SwingUtilities.invokeLater(() -> {
                int lineCount = textArea.getLineCount();
                if (lineCount > 512) {
                    try {
                        textArea.replaceRange("...\n", 0, textArea.getLineEndOffset(lineCount - 512 - 1));
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
                String logMsg = this.outputBuffer.toString();
                this.outputBuffer.reset();
                textArea.append(logMsg);
            });
        }
    }

    public static void setTextArea(JTextArea textArea) {
        GUIHandler.textArea = textArea;
    }
}

