/*
 * Decompiled with CFR 0.152.
 */
package clsvis.gui.worker;

import clsvis.ProjectConfigIO;
import clsvis.Utils;
import clsvis.gui.MainFrame;
import clsvis.gui.worker.BaseTask;
import clsvis.model.ProjectConfig;
import clsvis.process.importer.BaseProjectImporter;
import clsvis.process.importer.CompiledClassImporter;
import clsvis.process.importer.ImportProgressListener;
import java.io.IOException;

public class ClassProcessorTask
extends BaseTask<Void, Void>
implements ImportProgressListener {
    private final ProjectConfig config;
    private final ProjectConfig mainProjectConfig;
    private final BaseProjectImporter projectImporter;
    private boolean somethingToBeDone;
    private boolean refreshUI;
    private String projectTitle;
    private String errorMessage;

    public ClassProcessorTask(MainFrame mainFrame, ProjectConfig config) {
        super(mainFrame);
        this.config = config;
        this.mainProjectConfig = mainFrame.getProjectConfig();
        this.projectImporter = mainFrame.getProjectImporter();
    }

    @Override
    protected Void doInBackground() throws Exception {
        if (this.config.isPathToBeUsedForProjectLoad()) {
            this.loadProjectConfig();
            this.projectTitle = this.config.path.toString();
        } else {
            this.projectTitle = this.config.isPathSet() ? this.config.path.toString() + " (modified)" : "new project";
        }
        if (!this.config.classPaths.isEmpty()) {
            this.somethingToBeDone = true;
            this.addToClasspath();
        }
        if (!this.config.importPaths.isEmpty()) {
            this.somethingToBeDone = true;
            this.importClasses();
        }
        if (!this.somethingToBeDone) {
            this.logWarning("Nothing to be done");
        }
        return null;
    }

    private void setErrorMessage(String errorMessage) {
        if (this.errorMessage == null) {
            this.errorMessage = errorMessage;
        }
    }

    private void loadProjectConfig() throws IOException {
        this.logInfo("Opening project: " + String.valueOf(this.config.path));
        this.setErrorMessage("Error during opening project: ");
        ProjectConfig newConfig = ProjectConfigIO.load(this.config.path);
        this.config.setContent(this.config.path, newConfig);
        this.mainProjectConfig.setContent(this.config.path, newConfig);
    }

    private void addToClasspath() {
        this.logInfo("Adding elements to the class path");
        this.setErrorMessage("Error during adding elements to the classpath: ");
        int classPathsCountBefore = this.projectImporter.getClassPaths().size();
        this.projectImporter.addClassPaths(this.config.classPaths);
        int finalClassPathsCount = this.projectImporter.getClassPaths().size();
        int delta = finalClassPathsCount - classPathsCountBefore;
        if (delta > 0) {
            this.mainProjectConfig.addContent(this.config);
            this.logInfo(String.format("%d new element(s) added to class path; total count: %d", delta, finalClassPathsCount));
        } else {
            this.logWarning("No new elements added to class path");
        }
    }

    private void importClasses() {
        this.logInfo("Loading classes");
        this.setErrorMessage("Error during project import: ");
        CompiledClassImporter classImporter = this.projectImporter.getClassImporter();
        classImporter.setImportProgressListener(this);
        int startClassesCount = classImporter.getImportedClasses().size();
        long startTimeMs = System.currentTimeMillis();
        this.projectImporter.importProject(this.config.importPaths);
        double durationSeconds = (double)(System.currentTimeMillis() - startTimeMs) / 1000.0;
        int endClassesCount = classImporter.getImportedClasses().size();
        int failedClassesCount = classImporter.getNotImportedClassesCount();
        int delta = endClassesCount - startClassesCount;
        if (delta > 0) {
            this.mainProjectConfig.addContent(this.config);
            this.refreshUI = true;
            String msg = failedClassesCount == 0 ? String.format("Project imported successfully: %d classes within %.3fs.", delta, durationSeconds) : String.format("Project imported with some problems: %d classes within %.3fs (%d classes not imported). HINT: Add missing dependencies with 'File -> Add Required Libraries'", delta, durationSeconds, failedClassesCount);
            this.logInfo(msg);
        } else {
            this.logWarning("No classes imported");
        }
        this.projectImporter.cleanupAfterImport();
    }

    @Override
    protected void onSuccessGuiUpdate(Void result) {
        if (this.refreshUI) {
            this.mainFrame.setTitle(this.projectTitle);
            this.mainFrame.showClasses();
        }
    }

    @Override
    protected void onFailureGuiUpdate(Exception cause) {
        this.logSevere(this.errorMessage + Utils.rootCauseAsString(cause));
        this.logger.throwing("", "", cause);
        this.config.path = null;
        this.projectImporter.cleanupAfterImport();
    }

    @Override
    protected void afterDoneGuiUpdate() {
        System.gc();
    }

    @Override
    public void importProgress(int importedCount, int totalCount) {
        this.setProgress(importedCount * 100 / totalCount);
    }
}

