/*
 * Decompiled with CFR 0.152.
 */
package clsvis.gui.graph;

import clsvis.gui.ColorContext;
import clsvis.gui.ConstantValues;
import clsvis.gui.StructureBuilder;
import clsvis.gui.graph.Edge;
import clsvis.gui.graph.EdgeLineStyle;
import clsvis.gui.graph.SideGraphLayoutBuilder;
import clsvis.gui.graph.Vertex;
import clsvis.model.Class_;
import clsvis.model.RelationType;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.TransferHandler;
import javax.swing.UIManager;

public final class GraphComponent
extends JPanel
implements Scrollable {
    private static final Logger logger = Logger.getLogger(GraphComponent.class.getName());
    private static final BasicStroke border = new BasicStroke(2.0f);
    private static final BasicStroke solidLine = new BasicStroke(1.0f);
    private static final BasicStroke dashedLine = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{10.0f}, 0.0f);
    private static final SideGraphLayoutBuilder layoutBuilder = new SideGraphLayoutBuilder();
    private static final Map<RelationType, Color> relationColors = new EnumMap<RelationType, Color>(RelationType.class);
    private final int size = 12;
    private final Font classFont = new Font("SansSerif", 1, 12);
    private final Font abstractClassFont = new Font("SansSerif", 3, 12);
    private final Color selectedClassForeground = Color.red;
    private final Color classForeground;
    private final Color classUnprocessedForeground;
    private Class_ mainClass;
    private Vertex selectedVertex;
    private Vertex prevSelectedVertex;
    private PaintAction paintAction;
    private final int cellPadding = 12;
    private final int cellSpacing = 12;
    private List<Vertex> vertices;
    private List<Edge> edges;

    public GraphComponent() {
        this.classForeground = new Color(ColorContext.ClassProcessed.colorInt);
        this.classUnprocessedForeground = new Color(ColorContext.ClassUnprocessed.colorInt);
        this.cellPadding = 12;
        this.cellSpacing = 12;
        this.vertices = Collections.EMPTY_LIST;
        this.edges = Collections.EMPTY_LIST;
        this.getActionMap().put(TransferHandler.getCopyAction().getValue("Name"), TransferHandler.getCopyAction());
        this.setTransferHandler(new GraphTransferHandler());
        this.setFocusable(true);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Color bgColor = UIManager.getColor("TextArea.background");
        this.setBackground(bgColor);
        Container parent = this.getParent();
        if (parent instanceof JViewport) {
            parent.setBackground(bgColor);
        }
    }

    private void prepareLayout() {
        logger.finest("---- prepareLayout");
        this.vertices = new ArrayList<Vertex>(1024);
        this.edges = new ArrayList<Edge>(1024);
        Dimension graphSize = this.getPreferredSize();
        layoutBuilder.buildGraphLayout(this.mainClass, this.vertices, this.edges, graphSize, 12, 12, this.getFontMetrics(this.classFont), this.getFontMetrics(this.abstractClassFont));
        this.setPreferredSize(graphSize);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this.getClass().getSimpleName() + ".paintComponent");
        }
        long timeStart = System.currentTimeMillis();
        super.paintComponent(g2);
        this.paintGraph(g2);
        if (this.paintAction == PaintAction.SELECTED_ITEM) {
            this.paintSelection(g2);
        }
        this.paintAction = null;
        long timeStop = System.currentTimeMillis();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(String.format("-- painting time: %dms", timeStop - timeStart));
        }
    }

    private void paintGraph(Graphics2D g2) {
        g2.setColor(this.classForeground);
        for (int i = this.edges.size() - 1; i >= 0; --i) {
            this.drawEdge2(g2, this.edges.get(i));
        }
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
        g2.setStroke(border);
        for (Vertex vertex : this.vertices) {
            if (this.selectedVertex == null && vertex.main) {
                this.prevSelectedVertex = this.selectedVertex = vertex;
            }
            if (vertex.isRepresentsClass()) {
                g2.setColor(ConstantValues.backgroundColorMap.get((Object)vertex.class_.kind));
                g2.fill(vertex);
            }
            g2.setColor(!vertex.class_.relationsProcessed && vertex.isRepresentsClass() ? this.classUnprocessedForeground : this.classForeground);
            g2.setFont(vertex.class_.isAbstract() && vertex.isRepresentsClass() ? this.abstractClassFont : this.classFont);
            g2.drawString(vertex.getTitle(), vertex.textX, vertex.textY);
            this.drawVertexOutline(g2, vertex);
        }
    }

    private void paintSelection(Graphics2D g2) {
        g2.setStroke(border);
        this.drawVertexOutline(g2, this.prevSelectedVertex);
        this.drawVertexOutline(g2, this.selectedVertex);
        this.prevSelectedVertex = this.selectedVertex;
    }

    private void drawVertexOutline(Graphics2D g2, Vertex vertex) {
        g2.setColor(vertex == this.selectedVertex ? this.selectedClassForeground : this.classForeground);
        g2.draw(vertex);
    }

    private void drawEdge2(Graphics2D g2, Edge edge) {
        g2.setColor(edge.relationType == RelationType.DependencyThrows || edge.relationType == RelationType.DependencyAnnotation ? relationColors.get((Object)edge.relationType) : this.classForeground);
        g2.setStroke(edge.lineStyle == EdgeLineStyle.Solid ? solidLine : dashedLine);
        int connectorCount = edge.connector.size();
        g2.draw(edge.connector.get(connectorCount - 1));
        g2.setStroke(solidLine);
        for (int i = connectorCount - 2; i >= 0; --i) {
            g2.draw(edge.connector.get(i));
        }
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        Vertex vertex = this.vertexAtPoint(event.getX(), event.getY());
        return vertex != null && vertex.isRepresentsClass() ? StructureBuilder.buildClassRelationsSummaryTable(vertex.class_) : null;
    }

    private Vertex vertexAtPoint(int x, int y) {
        for (Vertex vertex : this.vertices) {
            if (!vertex.contains(x, y)) continue;
            return vertex;
        }
        return null;
    }

    public Class_ getMainClass() {
        return this.mainClass;
    }

    public void setMainClass(Class_ mainClass) {
        this.mainClass = mainClass;
        this.paintAction = PaintAction.GRAPH;
        this.selectedVertex = null;
        this.prevSelectedVertex = null;
        this.prepareLayout();
        this.revalidate();
        this.repaint();
    }

    public Class_ selectVertexAt(int x, int y) {
        Vertex selectedVertex = this.vertexAtPoint(x, y);
        if (selectedVertex != null && selectedVertex != this.prevSelectedVertex && selectedVertex.isRepresentsClass()) {
            this.selectedVertex = selectedVertex;
            this.paintAction = PaintAction.SELECTED_ITEM;
            this.repaint();
        }
        return selectedVertex != null ? selectedVertex.class_ : null;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return (this.vertices.isEmpty() ? 0 : (orientation == 1 ? this.vertices.get((int)0).height : this.vertices.get((int)0).width)) + 12;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return (orientation == 1 ? visibleRect.height : visibleRect.width) - 12;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    static {
        for (RelationType relationType : RelationType.values()) {
            relationColors.put(relationType, new Color(relationType.colorNum));
        }
    }

    static class GraphTransferHandler
    extends TransferHandler {
        GraphTransferHandler() {
        }

        @Override
        protected Transferable createTransferable(JComponent comp) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.getClass().getSimpleName() + ".createTransferable");
            }
            if (!(comp instanceof GraphComponent)) {
                throw new IllegalStateException("Unsupported component type: " + comp.getClass().getName());
            }
            GraphComponent graphComponent = (GraphComponent)comp;
            Dimension size = graphComponent.getPreferredSize();
            BufferedImage image = new BufferedImage(size.width, size.height, 1);
            Graphics2D g = image.createGraphics();
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, size.width, size.height);
            graphComponent.paintGraph(g);
            return new GraphTransferable(image);
        }

        @Override
        public int getSourceActions(JComponent comp) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.getClass().getSimpleName() + ".getSourceActions");
            }
            return 1;
        }

        @Override
        public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
            return false;
        }

        @Override
        public void exportToClipboard(JComponent comp, Clipboard clip, int action) throws IllegalStateException {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.getClass().getSimpleName() + ".exportToClipboard");
            }
            super.exportToClipboard(comp, clip, action);
        }
    }

    private static enum PaintAction {
        GRAPH,
        SELECTED_ITEM;

    }

    static class GraphTransferable
    implements Transferable {
        private static final DataFlavor[] SUPPORTED_DATA_FLAVORS = new DataFlavor[]{DataFlavor.imageFlavor};
        private final Image transferData;

        public GraphTransferable(Image transferData) {
            this.transferData = transferData;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return SUPPORTED_DATA_FLAVORS;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return DataFlavor.imageFlavor.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.transferData;
        }
    }
}

